<?php
require_once '../../config/config.php';
require_once '../../config/auth.php';
require_once '../../config/database.php';

require_once '../../templates/header.php';
require_once '../../templates/sidebar.php';

// ambil data pinjaman
$sql = "SELECT p.*, a.nama 
        FROM pinjaman p 
        JOIN anggota a ON p.anggota_id = a.id
        ORDER BY p.tanggal DESC";
$result = $db->query($sql);
?>

<h2>Verifikasi Pinjaman</h2>

<table class="table">
    <thead>
        <tr>
            <th>No</th>
            <th>Nama Anggota</th>
            <th>Jumlah</th>
            <th>Lama</th>
            <th>Status</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
        <?php $no = 1; while ($row = $result->fetch_assoc()): ?>
        <tr>
            <td><?= $no++; ?></td>
            <td><?= $row['nama']; ?></td>
            <td>Rp <?= number_format($row['jumlah'], 0, ',', '.'); ?></td>
            <td><?= $row['lama']; ?> bulan</td>
            <td><?= ucfirst($row['status']); ?></td>
            <td>
                <?php if ($row['status'] == 'menunggu'): ?>
                <form action="../../process/pinjaman_process.php" method="POST" style="display:inline">
                    <input type="hidden" name="aksi" value="verifikasi">
                    <input type="hidden" name="id" value="<?= $row['id']; ?>">
                    <input type="hidden" name="status" value="disetujui">
                    <button class="btn btn-primary">Setujui</button>
                </form>

                <form action="../../process/pinjaman_process.php" method="POST" style="display:inline">
                    <input type="hidden" name="aksi" value="verifikasi">
                    <input type="hidden" name="id" value="<?= $row['id']; ?>">
                    <input type="hidden" name="status" value="ditolak">
                    <button class="btn btn-danger">Tolak</button>
                </form>
                <?php else: ?>
                    -
                <?php endif; ?>
            </td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<?php require_once '../../templates/footer.php'; ?>
